#include <GMLuaModule.h>
#include <engine/ienginesound.h>
#include <filesystem_init.h>

#define ISOUND_NAME "ISound"
#define ISOUND_ID 9088

GMOD_MODULE(Load, Unload);

ILuaInterface *gLua = NULL;
IEngineSound *sengine = NULL;
IFileSystem *fsystem = NULL;

LUA_FUNCTION(EmitAmbientSound)
{
	gLua->CheckType(1, GLua::TYPE_STRING);
	gLua->CheckType(2, GLua::TYPE_NUMBER);
	gLua->CheckType(3, GLua::TYPE_NUMBER);

	sengine->EmitAmbientSound(gLua->GetString(1), gLua->GetInteger(2), gLua->GetInteger(3), gLua->GetInteger(4), gLua->GetInteger(5));

	return 0;
}

LUA_FUNCTION(GetAll)
{
	ILuaObject *rTable = gLua->GetNewTable();
	
	CUtlVector <SndInfo_t> activeS;
	sengine->GetActiveSounds(activeS);

	for (int i=0;i<activeS.Count();i++)
	{
		if (!sengine->IsSoundStillPlaying(activeS[i].m_nGuid))
			continue;

		SndInfo_t *sInfo = new SndInfo_t;
		memcpy(sInfo, &activeS[i], sizeof(SndInfo_t));
		
		gLua->PushUserData(gLua->GetMetaTable(ISOUND_NAME, ISOUND_ID), sInfo);
		rTable->SetMember(i+1, gLua->GetObject());
	}

	gLua->Push(rTable);

	rTable->UnReference();
	
	return 1;
}

LUA_FUNCTION(Duration)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	char fn[512];

	fsystem->String(sInfo->m_filenameHandle, fn, sizeof(fn));

	gLua->Push(sengine->GetSoundDuration(fn));

	return 1;
}

LUA_FUNCTION(Stop)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	sengine->StopSoundByGuid(sInfo->m_nGuid);

	return 0;
}

LUA_FUNCTION(SetVolume)
{
	gLua->CheckType(1, ISOUND_ID);
	gLua->CheckType(2, GLua::TYPE_NUMBER);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	sengine->SetVolumeByGuid(sInfo->m_nGuid, gLua->GetInteger(2));

	return 0;
}

LUA_FUNCTION(DryMix)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->Push(sInfo->m_bDryMix);

	return 1;
}

LUA_FUNCTION(FromServer)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->Push(sInfo->m_bFromServer);

	return 1;
}

LUA_FUNCTION(Sentence)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->Push(sInfo->m_bIsSentence);

	return 1;
}

LUA_FUNCTION(SourceSpeakerEntity)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->Push(sInfo->m_bSpeaker);

	return 1;
}

LUA_FUNCTION(Updateable)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->Push(sInfo->m_bUpdatePositions);

	return 1;
}

LUA_FUNCTION(Name)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	char fn[512];

	fsystem->String(sInfo->m_filenameHandle, fn, sizeof(fn));

	gLua->Push(fn);

	return 1;
}

LUA_FUNCTION(LastSpatializedVolume)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->Push(sInfo->m_flLastSpatializedVolume);

	return 1;
}

LUA_FUNCTION(Radius)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->Push(sInfo->m_flRadius);

	return 1;
}

LUA_FUNCTION(GetVolume)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->Push(sInfo->m_flVolume);

	return 1;
}

LUA_FUNCTION(Channel)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->PushDouble(sInfo->m_nChannel);

	return 1;
}

LUA_FUNCTION(GUID)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->PushDouble(sInfo->m_nGuid);

	return 1;
}

LUA_FUNCTION(Pitch)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->PushDouble(sInfo->m_nPitch);

	return 1;
}

LUA_FUNCTION(Source)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->PushDouble(sInfo->m_nSoundSource);

	return 1;
}

LUA_FUNCTION(SpeakerEntity)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->PushDouble(sInfo->m_nSpeakerEntity);

	return 1;
}

LUA_FUNCTION(Direction)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->Push(gLua->GetGlobal("Vector"));
	gLua->Push(sInfo->m_pDirection->x);
	gLua->Push(sInfo->m_pDirection->y);
	gLua->Push(sInfo->m_pDirection->z);

	gLua->Call(3, 1);

	gLua->Push(gLua->GetReturn(0));

	return 1;
}

LUA_FUNCTION(Origin)
{
	gLua->CheckType(1, ISOUND_ID);

	SndInfo_t *sInfo = (SndInfo_t*)gLua->GetUserData(1);
	
	gLua->Push(gLua->GetGlobal("Vector"));
	gLua->Push(sInfo->m_pOrigin->x);
	gLua->Push(sInfo->m_pOrigin->y);
	gLua->Push(sInfo->m_pOrigin->z);

	gLua->Call(3, 1);

	gLua->Push(gLua->GetReturn(0));

	return 1;
}

LUA_FUNCTION(GetGuidForLastSoundEmitted)
{
	gLua->PushDouble(sengine->GetGuidForLastSoundEmitted());

	return 1;
}

LUA_FUNCTION(IsSoundPrecached)
{
	gLua->CheckType(1, GLua::TYPE_STRING);

	gLua->Push(sengine->IsSoundPrecached(gLua->GetString(1)));

	return 1;
}

LUA_FUNCTION(IsSoundStillPlaying)
{
	gLua->CheckType(1, GLua::TYPE_NUMBER);

	gLua->Push(sengine->IsSoundStillPlaying(gLua->GetInteger(1)));

	return 1;
}

LUA_FUNCTION(PrecacheSentenceGroup)
{
	gLua->CheckType(1, GLua::TYPE_STRING);

	sengine->PrecacheSentenceGroup(gLua->GetString(1));

	return 0;
}

LUA_FUNCTION(PrecacheSound)
{
	gLua->CheckType(1, GLua::TYPE_STRING);

	sengine->PrecacheSound(gLua->GetString(1), gLua->GetBool(2), gLua->GetBool(3));

	return 0;
}

LUA_FUNCTION(PrefetchSound)
{
	gLua->CheckType(1, GLua::TYPE_STRING);

	sengine->PrefetchSound(gLua->GetString(1));

	return 0;
}

LUA_FUNCTION(StopAllSounds)
{
	sengine->StopAllSounds(true);
	
	return 0;
}

LUA_FUNCTION(StopSound)
{
	gLua->CheckType(1, GLua::TYPE_NUMBER);
	gLua->CheckType(2, GLua::TYPE_NUMBER);
	gLua->CheckType(3, GLua::TYPE_STRING);

	sengine->StopSound(gLua->GetInteger(1), gLua->GetInteger(2), gLua->GetString(3));
	
	return 0;
}

int Load(lua_State *L)
{
	CreateInterfaceFn IEngine = Sys_GetFactory("engine.dll");
	sengine = (IEngineSound*)IEngine(IENGINESOUND_CLIENT_INTERFACE_VERSION, NULL);

	CreateInterfaceFn IFSystem = Sys_GetFactory("FileSystem_Steam.dll");
	fsystem = (IFileSystem*)IFSystem(FILESYSTEM_INTERFACE_VERSION, NULL);

	if (!sengine || !fsystem) return 0;

	gLua = Lua();

	ILuaObject *mTable = gLua->GetMetaTable(ISOUND_NAME, ISOUND_ID);
		ILuaObject *__index = gLua->GetNewTable();
			__index->SetMember("Duration", Duration);
			__index->SetMember("Stop", Stop);
			__index->SetMember("SetVolume", SetVolume);

			__index->SetMember("DryMix", DryMix);	
			__index->SetMember("FromServer", FromServer);			
			__index->SetMember("Sentence", Sentence);
			__index->SetMember("SourceSpeakerEntity", SourceSpeakerEntity);		
			__index->SetMember("Updateable", Updateable);
			__index->SetMember("Name", Name);
			__index->SetMember("LastSpatializedVolume", LastSpatializedVolume);			
			__index->SetMember("Radius", Radius);
			__index->SetMember("GetVolume", GetVolume);
			__index->SetMember("Channel", Channel);
			__index->SetMember("GUID", GUID);
			__index->SetMember("Pitch", Pitch);
			__index->SetMember("Source", Source);
			__index->SetMember("SpeakerEntity", SpeakerEntity);
			__index->SetMember("Direction", Direction);
			__index->SetMember("Origin", Origin);
		
			mTable->SetMember("__index", __index);
		__index->UnReference();
	mTable->UnReference();

	gLua->NewGlobalTable("sound");

	ILuaObject *sTable = gLua->GetGlobal("sound");
		sTable->SetMember("EmitAmbientSound", EmitAmbientSound);
		sTable->SetMember("GetAll", GetAll);
		sTable->SetMember("GetGuidForLastSoundEmitted", GetGuidForLastSoundEmitted);
		sTable->SetMember("IsSoundPrecached", IsSoundPrecached);
		sTable->SetMember("IsSoundStillPlaying", IsSoundStillPlaying);
		sTable->SetMember("PrecacheSentenceGroup", PrecacheSentenceGroup);
		sTable->SetMember("PrecacheSound", PrecacheSound);
		sTable->SetMember("PrefetchSound", PrefetchSound);
		sTable->SetMember("StopAllSounds", StopAllSounds);
		sTable->SetMember("StopSound", StopSound);	
	sTable->UnReference();

	return 0;
}

int Unload(lua_State *L)
{
	return 0;
}