#include "../gminterface/include/GMLuaModule.h"
#include "../msgclasses/svc_createstringtable.h"
#include "svc_createstringtable_l.h"

extern ILuaInterface *gLua;

namespace MT_SVC_CreateStringTable
{
	LUA_FUNCTION(GetTableName)
	{
		gLua->CheckType(1, SVC_CREATESTRINGTABLE_ID);

		SVC_CreateStringTable *msg = (SVC_CreateStringTable *)gLua->GetUserData(1);

		gLua->Push(msg->GetTableName());

		return 1;
	}

	LUA_FUNCTION(SetTableName)
	{
		gLua->CheckType(1, SVC_CREATESTRINGTABLE_ID);
		gLua->CheckType(2, GLua::TYPE_STRING);

		SVC_CreateStringTable *msg = (SVC_CreateStringTable *)gLua->GetUserData(1);

		msg->SetTableName(gLua->GetString(2));
		
		return 0;
	}

	LUA_FUNCTION(GetEntryCount)
	{
		gLua->CheckType(1, SVC_CREATESTRINGTABLE_ID);

		SVC_CreateStringTable *msg = (SVC_CreateStringTable *)gLua->GetUserData(1);

		gLua->PushDouble(msg->GetEntryCount());

		return 1;
	}

	LUA_FUNCTION(SetEntryCount)
	{
		gLua->CheckType(1, SVC_CREATESTRINGTABLE_ID);
		gLua->CheckType(2, GLua::TYPE_NUMBER);

		SVC_CreateStringTable *msg = (SVC_CreateStringTable *)gLua->GetUserData(1);

		msg->SetEntryCount(gLua->GetInteger(2));

		return 0;
	}
}