#include "../gminterface/include/GMLuaModule.h"
#include "../msgclasses/net_signonstate.h"
#include "net_signonstate_l.h"

extern ILuaInterface *gLua;

namespace MT_NET_SignonState
{
	LUA_FUNCTION(GetState)
	{
		gLua->CheckType(1, NET_SIGNONSTATE_ID);

		NET_SignonState  *msg = (NET_SignonState *)gLua->GetUserData(1);

		gLua->PushDouble(msg->GetState());

		return 1;
	}

	LUA_FUNCTION(SetState)
	{
		gLua->CheckType(1, NET_SIGNONSTATE_ID);
		gLua->CheckType(2, GLua::TYPE_NUMBER);

		NET_SignonState  *msg = (NET_SignonState *)gLua->GetUserData(1);

		msg->SetState(gLua->GetInteger(2));

		return 0;
	}

	LUA_FUNCTION(GetCount)
	{
		gLua->CheckType(1, NET_SIGNONSTATE_ID);

		NET_SignonState  *msg = (NET_SignonState *)gLua->GetUserData(1);

		gLua->PushDouble(msg->GetCount());

		return 1;
	}

	LUA_FUNCTION(SetCount)
	{
		gLua->CheckType(1, NET_SIGNONSTATE_ID);
		gLua->CheckType(2, GLua::TYPE_NUMBER);

		NET_SignonState  *msg = (NET_SignonState *)gLua->GetUserData(1);

		msg->SetCount(gLua->GetInteger(2));

		return 0;
	}
}