#include "../gminterface/include/GMLuaModule.h"
#include "../msgclasses/net_setconvar.h"
#include "net_setconvar_l.h"

extern ILuaInterface *gLua;

namespace MT_NET_SetConVar
{
	LUA_FUNCTION(GetConVarCount)
	{
		gLua->CheckType(1, NET_SETCONVAR_ID);

		NET_SetConVar *msg = (NET_SetConVar *)gLua->GetUserData(1);
		
		gLua->PushDouble(msg->GetConVarCount());

		return 1;
	}

	LUA_FUNCTION(SetConVarCount)
	{
		gLua->CheckType(1, NET_SETCONVAR_ID);
		gLua->CheckType(2, GLua::TYPE_NUMBER);

		NET_SetConVar *msg = (NET_SetConVar *)gLua->GetUserData(1);
		
		msg->SetConVarCount(gLua->GetInteger(2));

		return 0;
	}

	LUA_FUNCTION(GetConVar)
	{
		gLua->CheckType(1, NET_SETCONVAR_ID);
		gLua->CheckType(2, GLua::TYPE_NUMBER);

		NET_SetConVar *msg = (NET_SetConVar *)gLua->GetUserData(1);
		
		int index = gLua->GetInteger(2)-1;

		char *cvars = msg->GetConVars();

		ILuaObject *returnT = gLua->GetNewTable();

		char name[260];

		for (int i=index*520;i<((index*520)+260);i++)
		{
			char cv = cvars[i];

			name[i-(index*520)] = cv;

			if (cv == '\0')
			{
				returnT->SetMember("Name", name);

				break;
			}
		}

		char value[260];

		for (int i=(index*520)+260;i<((index*520)+520);i++)
		{
			char cv = cvars[i];

			value[i-((index*520)+260)] = cv;

			if (cv == '\0')
			{
				returnT->SetMember("Value", value);

				break;
			}
		}

		gLua->Push(returnT);;

		returnT->UnReference();

		return 1;
	}

	LUA_FUNCTION(SetConVar)
	{
		gLua->CheckType(1, NET_SETCONVAR_ID);
		gLua->CheckType(2, GLua::TYPE_NUMBER);
		gLua->CheckType(3, GLua::TYPE_STRING);
		gLua->CheckType(4, GLua::TYPE_STRING);

		NET_SetConVar *msg = (NET_SetConVar *)gLua->GetUserData(1);

		int index = gLua->GetInteger(2)-1;

		char *cvars = msg->GetConVars();

		const char *name = gLua->GetString(3);

		for (int i=index*520;i<((index*520)+260);i++)
		{
			char cv = name[i-(index*520)];

			cvars[i] = cv;

			if (cv == '\0')
			{
				break;
			}
		}
		
		const char *value = gLua->GetString(4);

		for (int i=(index*520)+260;i<((index*520)+520);i++)
		{
			char cv = value[i-((index*520)+260)];

			cvars[i] = cv;

			if (cv == '\0')
			{
				break;
			}
		}

		return 0;
	}
}