#include "../gminterface/include/GMLuaModule.h"
#include <inetmessage.h>
#include <inetchannel.h>
#include "inetmessage_l.h"
#include "inetchannel_l.h"

extern ILuaInterface *gLua;

namespace MT_INetMessage
{
	LUA_FUNCTION(To)
	{
		gLua->CheckType(1, INETMESSAGE_ID);
		gLua->CheckType(2, GLua::TYPE_TABLE);

		gLua->PushUserData(gLua->GetObject(2), gLua->GetUserData(1));

		return 1;
	}

	LUA_FUNCTION(SetReliable)
	{
		gLua->CheckType(1, INETMESSAGE_ID);
		gLua->CheckType(2, GLua::TYPE_BOOL);

		INetMessage *msg = (INetMessage *)gLua->GetUserData(1);

		msg->SetReliable(gLua->GetBool(2));

		return 0;
	}

	LUA_FUNCTION(Process)
	{
		gLua->CheckType(1, INETMESSAGE_ID);

		INetMessage *msg = (INetMessage *)gLua->GetUserData(1);

		gLua->Push(msg->Process());

		return 1;
	}

	LUA_FUNCTION(IsReliable)
	{
		gLua->CheckType(1, INETMESSAGE_ID);

		INetMessage *msg = (INetMessage *)gLua->GetUserData(1);

		gLua->Push(msg->IsReliable());

		return 1;
	}

	LUA_FUNCTION(GetType)
	{
		gLua->CheckType(1, INETMESSAGE_ID);

		INetMessage *msg = (INetMessage *)gLua->GetUserData(1);

		gLua->PushDouble(msg->GetType());

		return 1;
	}

	LUA_FUNCTION(GetGroup)
	{
		gLua->CheckType(1, INETMESSAGE_ID);

		INetMessage *msg = (INetMessage *)gLua->GetUserData(1);

		gLua->PushDouble(msg->GetGroup());

		return 1;
	}

	LUA_FUNCTION(GetName)
	{
		gLua->CheckType(1, INETMESSAGE_ID);

		INetMessage *msg = (INetMessage *)gLua->GetUserData(1);

		gLua->Push(msg->GetName());

		return 1;
	}

	LUA_FUNCTION(GetNetChannel)
	{
		gLua->CheckType(1, INETMESSAGE_ID);

		INetMessage *msg = (INetMessage *)gLua->GetUserData(1);
		INetChannel *netchan = msg->GetNetChannel();

		if (netchan)
		{
			ILuaObject *metaT = gLua->GetMetaTable(INETCHANNEL_NAME, INETCHANNEL_ID);
				gLua->PushUserData(metaT, netchan);
			metaT->UnReference();
		}
		else
		{
			gLua->PushNil();
		}

		return 1;
	}

	LUA_FUNCTION(ToString)
	{
		gLua->CheckType(1, INETMESSAGE_ID);
		
		INetMessage *msg = (INetMessage *)gLua->GetUserData(1);

		gLua->Push(msg->ToString());

		return 1;
	}
}