#include <eiface.h>
#include <cdll_int.h>

IVEngineServer *sv_engine = NULL;
IVEngineClient *cl_engine = NULL;

bool client = false;
int loadcount = 0;

#include <inetmsghandler.h>
#include <inetchannelinfo.h>
#include <inetchannel.h>
#include <inetmessage.h>
#include <iclient.h>

#include "gminterface/include/GMLuaModule.h"

extern "C"
{
#include "lua_shared/include/lua.h"
#include "lua_shared/include/lauxlib.h"
}

lua_State *g_L = NULL;

GMOD_MODULE(Load, Unload);

ILuaInterface *gLua = NULL;

#include "msgclasses/cnetmessage.h"
#include "msgclasses/clc_baselineack.h"
#include "msgclasses/clc_clientinfo.h"
#include "msgclasses/clc_filecrccheck.h"
#include "msgclasses/clc_listenevents.h"
#include "msgclasses/clc_move.h"
#include "msgclasses/clc_respondcvarvalue.h"
#include "msgclasses/clc_voicedata.h"
#include "msgclasses/net_setconvar.h"
#include "msgclasses/net_signonstate.h"
#include "msgclasses/net_stringcmd.h"
#include "msgclasses/net_tick.h"
#include "msgclasses/svc_bspdecal.h"
#include "msgclasses/svc_classinfo.h"
#include "msgclasses/svc_createstringtable.h"
#include "msgclasses/svc_crosshairangle.h"
#include "msgclasses/svc_entitymessage.h"
#include "msgclasses/svc_fixangle.h"
#include "msgclasses/svc_gameevent.h"
#include "msgclasses/svc_gameeventlist.h"
#include "msgclasses/svc_getcvarvalue.h"
#include "msgclasses/svc_menu.h"
#include "msgclasses/svc_packetentities.h"
#include "msgclasses/svc_prefetch.h"
#include "msgclasses/svc_print.h"
#include "msgclasses/svc_sendtable.h"
#include "msgclasses/svc_serverinfo.h"
#include "msgclasses/svc_setpause.h"
#include "msgclasses/svc_setview.h"
#include "msgclasses/svc_sounds.h"
#include "msgclasses/svc_tempentities.h"
#include "msgclasses/svc_terrainmod.h"
#include "msgclasses/svc_updatestringtable.h"
#include "msgclasses/svc_usermessage.h"
#include "msgclasses/svc_voicedata.h"
#include "msgclasses/svc_voiceinit.h"

#include "luaclasses/inetchannel_l.h"
#include "luaclasses/inetmessage_l.h"
#include "luaclasses/clc_baselineack_l.h"
#include "luaclasses/clc_clientinfo_l.h"
#include "luaclasses/clc_filecrccheck_l.h"
#include "luaclasses/clc_listenevents_l.h"
#include "luaclasses/clc_move_l.h"
#include "luaclasses/clc_respondcvarvalue_l.h"
#include "luaclasses/clc_voicedata_l.h"
#include "luaclasses/net_setconvar_l.h"
#include "luaclasses/net_signonstate_l.h"
#include "luaclasses/net_stringcmd_l.h"
#include "luaclasses/net_tick_l.h"
#include "luaclasses/svc_bspdecal_l.h"
#include "luaclasses/svc_classinfo_l.h"
#include "luaclasses/svc_createstringtable_l.h"
#include "luaclasses/svc_crosshairangle_l.h"
#include "luaclasses/svc_entitymessage_l.h"
#include "luaclasses/svc_fixangle_l.h"
#include "luaclasses/svc_gameevent_l.h"
#include "luaclasses/svc_gameeventlist_l.h"
#include "luaclasses/svc_getcvarvalue_l.h"
#include "luaclasses/svc_menu_l.h"
#include "luaclasses/svc_packetentities_l.h"
#include "luaclasses/svc_prefetch_l.h"
#include "luaclasses/svc_print_l.h"
#include "luaclasses/svc_sendtable_l.h"
#include "luaclasses/svc_serverinfo_l.h"
#include "luaclasses/svc_setpause_l.h"
#include "luaclasses/svc_setview_l.h"
#include "luaclasses/svc_sounds_l.h"
#include "luaclasses/svc_tempentities_l.h"
#include "luaclasses/svc_terrainmod_l.h"
#include "luaclasses/svc_updatestringtable_l.h"
#include "luaclasses/svc_usermessage_l.h"
#include "luaclasses/svc_voicedata_l.h"
#include "luaclasses/svc_voiceinit_l.h"

#include "cdetour.h"
#include "sigscan/include/sigscan.h"

#define GetObject GetObject

#define CL_PROCESSFUNC(type) CSigScan CL_Process##type##_Sig //CClientState
#define SV_PROCESSFUNC(type) CSigScan SV_Process##type##_Sig //CBaseClient

SV_PROCESSFUNC(SetConVar);
SV_PROCESSFUNC(SignonState);
SV_PROCESSFUNC(StringCmd);
SV_PROCESSFUNC(Tick);

SV_PROCESSFUNC(BaselineAck);
SV_PROCESSFUNC(ClientInfo);
SV_PROCESSFUNC(FileCRCCheck);
SV_PROCESSFUNC(ListenEvents);
SV_PROCESSFUNC(Move);
SV_PROCESSFUNC(RespondCvarValue);
SV_PROCESSFUNC(VoiceData);

CL_PROCESSFUNC(SetConVar);
CL_PROCESSFUNC(SignonState);
CL_PROCESSFUNC(StringCmd);
CL_PROCESSFUNC(Tick);

CL_PROCESSFUNC(BSPDecal);
CL_PROCESSFUNC(ClassInfo);
CL_PROCESSFUNC(CreateStringTable);
CL_PROCESSFUNC(CrosshairAngle);
CL_PROCESSFUNC(EntityMessage);
CL_PROCESSFUNC(FixAngle);
CL_PROCESSFUNC(GameEvent);
CL_PROCESSFUNC(GameEventList);
CL_PROCESSFUNC(GetCvarValue);
CL_PROCESSFUNC(Menu);
CL_PROCESSFUNC(PacketEntities);
CL_PROCESSFUNC(Prefetch);
CL_PROCESSFUNC(Print);
CL_PROCESSFUNC(SendTable);
CL_PROCESSFUNC(ServerInfo);
CL_PROCESSFUNC(SetPause);
CL_PROCESSFUNC(SetView);
CL_PROCESSFUNC(Sounds);
CL_PROCESSFUNC(TempEntities);
CL_PROCESSFUNC(TerrainMod);
CL_PROCESSFUNC(UpdateStringTable);
CL_PROCESSFUNC(UserMessage);
CL_PROCESSFUNC(VoiceData);
CL_PROCESSFUNC(VoiceInit);

//CSigScan ProcessNetMsg_Sig;
CSigScan INetChannel_SendNetMsg_Sig;
CSigScan INetChannel_SendDatagram_Sig;

/*void CDetour::ProcessNetMsg()
{
	INetMessage *msg = NULL;

	__asm MOV msg, ESI

	ILuaObject *hookT = gLua->GetGlobal("hook");
		ILuaObject *callM = hookT->GetMember("Call");
			gLua->Push(callM);

			gLua->Push("ProcessNetMsg");
			gLua->PushNil();
			
			ILuaObject *metaT = gLua->GetMetaTable(INETMESSAGE_NAME, INETMESSAGE_ID);
				gLua->PushUserData(metaT, msg);
			metaT->UnReference();
		callM->UnReference();
	hookT->UnReference();

	gLua->Call(3, 1);

	ILuaObject *retL = gLua->GetReturn(0);

	bool bState = retL->isNil();

	retL->UnReference();

	(this->*ProcessNetMsgT)();
}*/

bool ShouldCallHook(const char *hookname)
{
	/*if (client)
	{
		if (!cl_engine->IsConnected())
		{
			Msg("Ignoring %s\n", hookname);

			return false;
		}
	}*/

	bool bContinue = true;

	ILuaObject *sourcenetT = gLua->GetGlobal("sourcenet");
	
	if (sourcenetT)
	{
		if (sourcenetT->isTable())
		{
			ILuaObject *sourcenetHT = sourcenetT->GetMember("hooks");
				
			if (sourcenetHT)
			{
				if (sourcenetHT->isTable())
				{
					ILuaObject *hookmem = sourcenetHT->GetMember(hookname);
							
					if (hookmem)
					{
						if ((!hookmem->isNil()) && (hookmem->GetBool() == false))
						{
							bContinue = false;
						}

						hookmem->UnReference();
					}
				}

				sourcenetHT->UnReference();
			}
		}

		sourcenetT->UnReference();
	}

	//Attempt to fix menu env crash below, no difference

	/*if (g_L)
	{
		lua_State *L = g_L;

		lua_getglobal(L, "sourcenet");

		if (lua_istable(L, -1))
		{
			lua_pushstring(L, "hooks");
			lua_gettable(L, -2);

			if (lua_istable(L, -1))
			{
				lua_pushstring(L, hookname);
				lua_gettable(L, -2);

				if ((lua_isboolean(L, -1)) && (lua_toboolean(L, -1) == 0))
				{
					bContinue = false;
				}

				lua_pop(L, 1);
			}

			lua_pop(L, 1);
		}

		lua_pop(L, 1);
	}
	else
	{
		bContinue = false;
	}*/

	return bContinue;
}

bool CDetour::SendNetMsgL(INetMessage &msg, bool bForceReliable, bool bVoice)
{
	return (this->*INetChannel_SendNetMsgT)(msg, bForceReliable, bVoice);
}

bool CDetour::INetChannel_SendNetMsg(INetMessage &msg, bool bForceReliable = false, bool bVoice = false)
{
	if (ShouldCallHook("SendNetMsg"))
	{
		ILuaObject *hookT = gLua->GetGlobal("hook");
			ILuaObject *callM = hookT->GetMember("Call");
				gLua->Push(callM);

				gLua->Push("SendNetMsg");
				gLua->PushNil();
				
				ILuaObject *metaT = gLua->GetMetaTable(INETMESSAGE_NAME, INETMESSAGE_ID);
					gLua->PushUserData(metaT, &msg);
				metaT->UnReference();

				gLua->Push(bForceReliable);
				gLua->Push(bVoice);
			callM->UnReference();
		hookT->UnReference();

		gLua->Call(5, 1);

		ILuaObject *retL = gLua->GetReturn(0);

		bool bState = retL->isNil();

		retL->UnReference();

		if (!bState)
			return true;
	}

	return (this->*INetChannel_SendNetMsgT)(msg, bForceReliable, bVoice);
}

int CDetour::INetChannel_SendDatagram(bf_write *data)
{
	/*if (data)
	{
		bf_read read(data, 1024);

		gLua->Msg("Sending something, %i\n", read.ReadByte());
	}
	else
		gLua->Msg("No data\n");*/

	return (this->*INetChannel_SendDatagramT)(data);
}

int GetPlayerEIndex(ILuaObject *playerEntity)
{
	ILuaObject *entityMT = gLua->GetMetaTable("Entity", GLua::TYPE_ENTITY);
		ILuaObject *entityM = entityMT->GetMember("EntIndex");
			entityM->Push();
					
			playerEntity->Push();

			gLua->Call(1, 1);
		entityM->UnReference();
	entityMT->UnReference();

	ILuaObject *returnL = gLua->GetReturn(0);

	int index = returnL->GetInt();

	returnL->UnReference();

	return index;
}

LUA_FUNCTION(NMToBase)
{
	ILuaObject *metaT = gLua->GetMetaTable(INETMESSAGE_NAME, INETMESSAGE_ID);
		gLua->PushUserData(metaT, gLua->GetUserData(1));
	metaT->UnReference();

	return 1;
}

LUA_FUNCTION(SV_GetNetChannel)
{
	gLua->CheckType(1, GLua::TYPE_ENTITY);

	INetChannel *playerNC = (INetChannel *)sv_engine->GetPlayerNetInfo(GetPlayerEIndex(gLua->GetObject(1)));
	
	if (playerNC)
	{
		ILuaObject *metaT = gLua->GetMetaTable(INETCHANNEL_NAME, INETCHANNEL_ID);
			gLua->PushUserData(metaT, playerNC);
		metaT->UnReference();
	}
	else
	{
		gLua->PushNil();
	}

	return 1;
}

LUA_FUNCTION(CL_GetNetChannel)
{
	INetChannel *playerNC = (INetChannel *)cl_engine->GetNetChannelInfo();

	if (playerNC)
	{
		ILuaObject *metaT = gLua->GetMetaTable(INETCHANNEL_NAME, INETCHANNEL_ID);
			gLua->PushUserData(metaT, playerNC);
		metaT->UnReference();
	}
	else
	{
		gLua->PushNil();
	}

	return 1;
}

bool CallProcessHook(INetMessage *msg, const char *hookname, const char *metaname, int metaid)
{
	if (ShouldCallHook(hookname))
	{
		ILuaObject *hookT = gLua->GetGlobal("hook");
		
		if (hookT->isTable())
		{
			ILuaObject *callM = hookT->GetMember("Call");

			if (callM->isFunction())
			{
				gLua->Push(callM);

				gLua->Push(hookname);
				gLua->PushNil();

				ILuaObject *metaT = gLua->GetMetaTable(metaname, metaid);

				if (metaT->isTable())
				{
					gLua->PushUserData(metaT, msg);
				}

				metaT->UnReference();
			}

			callM->UnReference();
		}

		hookT->UnReference();

		gLua->Call(3, 1);

		ILuaObject *retL = gLua->GetReturn(0);

		bool bState = retL->isNil();

		retL->UnReference();

		return bState;
	}

	return true;
}

#define ATTACHPROCESSFUNC(side, name, sig, mask, len) \
	side##_Process##name##_Sig.Init((unsigned char *)sig, mask, len); \
	if (side##_Process##name##_Sig.is_set) \
	{ \
		CDetour::side##_Process##name##T = *((side##_Process##name##_t)&side##_Process##name##_Sig.sig_addr); \
		DetourTransactionBegin(); \
		DetourUpdateThread(GetCurrentThread()); \
		DetourAttach(&(PVOID &)CDetour::side##_Process##name##T, (PVOID)(&(PVOID &)CDetour::side##_Process##name)); \
		DetourTransactionCommit(); \
	} \
	else \
	{ \
		gLua->Msg("[%s] Failed\n", #name); \
	}

#define DETACHPROCESSFUNC(side, name) \
	if (side##_Process##name##_Sig.is_set) \
	{ \
		DetourTransactionBegin(); \
		DetourUpdateThread(GetCurrentThread()); \
		DetourDetach(&(PVOID &)CDetour::side##_Process##name##T, (PVOID)(&(PVOID &)CDetour::side##_Process##name)); \
		DetourTransactionCommit(); \
	}

#define INITPROCESSFUNC(side, type, name, hookname, meta) \
	bool CDetour::side##_Process##name(type##_##name *msg) \
	{ \
		if (CallProcessHook(msg, hookname, type##_##meta##_##NAME, type##_##meta##_##ID)) \
		{ \
			return (this->*##side##_Process##name##T)(msg); \
		} \
		else \
		{ \
			return true; \
		} \
	}

INITPROCESSFUNC(SV, NET, SetConVar, "ProcessSetConVar", SETCONVAR);
INITPROCESSFUNC(SV, NET, SignonState, "ProcessSignonState", SIGNONSTATE);
INITPROCESSFUNC(SV, NET, StringCmd, "ProcessStringCmd", STRINGCMD);
INITPROCESSFUNC(SV, NET, Tick, "ProcessTick", TICK);

INITPROCESSFUNC(SV, CLC, BaselineAck, "ProcessBaselineAck", BASELINEACK);
INITPROCESSFUNC(SV, CLC, ClientInfo, "ProcessClientInfo", CLIENTINFO);
INITPROCESSFUNC(SV, CLC, FileCRCCheck, "ProcessFileCRCCheck", FILECRCCHECK);
INITPROCESSFUNC(SV, CLC, ListenEvents, "ProcessListenEvents", LISTENEVENTS);
INITPROCESSFUNC(SV, CLC, Move, "ProcessMove", MOVE);
INITPROCESSFUNC(SV, CLC, RespondCvarValue, "ProcessRespondCvarValue", RESPONDCVARVALUE);
INITPROCESSFUNC(SV, CLC, VoiceData, "ProcessVoiceData", VOICEDATA);

INITPROCESSFUNC(CL, NET, SetConVar, "ProcessSetConVar", SETCONVAR);
INITPROCESSFUNC(CL, NET, SignonState, "ProcessSignonState", SIGNONSTATE);
INITPROCESSFUNC(CL, NET, StringCmd, "ProcessStringCmd", STRINGCMD);
INITPROCESSFUNC(CL, NET, Tick, "ProcessTick", TICK);

INITPROCESSFUNC(CL, SVC, BSPDecal, "ProcessBSPDecal", BSPDECAL);
INITPROCESSFUNC(CL, SVC, ClassInfo, "ProcessClassInfo", CLASSINFO);
INITPROCESSFUNC(CL, SVC, CreateStringTable, "ProcessCreateStringTable", CREATESTRINGTABLE);
INITPROCESSFUNC(CL, SVC, CrosshairAngle, "ProcessCrosshairAngle", CROSSHAIRANGLE);
INITPROCESSFUNC(CL, SVC, EntityMessage, "ProcessEntityMessage", ENTITYMESSAGE);
INITPROCESSFUNC(CL, SVC, FixAngle, "ProcessFixAngle", FIXANGLE);
INITPROCESSFUNC(CL, SVC, GameEvent, "ProcessGameEvent", GAMEEVENT);
INITPROCESSFUNC(CL, SVC, GameEventList, "ProcessGameEventList", GAMEEVENTLIST);
INITPROCESSFUNC(CL, SVC, GetCvarValue, "ProcessGetCvarValue", GETCVARVALUE);
INITPROCESSFUNC(CL, SVC, Menu, "ProcessMenu", MENU);
INITPROCESSFUNC(CL, SVC, PacketEntities, "ProcessPacketEntities", PACKETENTITIES);
INITPROCESSFUNC(CL, SVC, Prefetch, "ProcessPrefetch", PREFETCH);
INITPROCESSFUNC(CL, SVC, Print, "ProcessPrint", PRINT);
INITPROCESSFUNC(CL, SVC, SendTable, "ProcessSendTable", SENDTABLE);
INITPROCESSFUNC(CL, SVC, ServerInfo, "ProcessServerInfo", SERVERINFO);
INITPROCESSFUNC(CL, SVC, SetPause, "ProcessSetPause", SETPAUSE);
INITPROCESSFUNC(CL, SVC, SetView, "ProcessSetView", SETVIEW);
INITPROCESSFUNC(CL, SVC, Sounds, "ProcessSounds", SOUNDS);
INITPROCESSFUNC(CL, SVC, TempEntities, "ProcessTempEntities", TEMPENTITIES);
//INITPROCESSFUNC(CL, SVC, TerrainMod, "ProcessTerrainMod", TERRAINMOD);
INITPROCESSFUNC(CL, SVC, UpdateStringTable, "ProcessUpdateStringTable", UPDATESTRINGTABLE);
INITPROCESSFUNC(CL, SVC, UserMessage, "ProcessUserMessage", USERMESSAGE);
INITPROCESSFUNC(CL, SVC, VoiceData, "ProcessVoiceData", VOICEDATA);
INITPROCESSFUNC(CL, SVC, VoiceInit, "ProcessVoiceInit", VOICEINIT);

int Load(lua_State *L)
{
	g_L = L;
	gLua = Lua();

	ILuaObject *metaT, *__index;

	metaT = gLua->GetMetaTable(CLC_BASELINEACK_NAME, CLC_BASELINEACK_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(CLC_CLIENTINFO_NAME, CLC_CLIENTINFO_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(CLC_FILECRCCHECK_NAME, CLC_FILECRCCHECK_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(CLC_LISTENEVENTS_NAME, CLC_LISTENEVENTS_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(CLC_MOVE_NAME, CLC_MOVE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(CLC_RESPONDCVARVALUE_NAME, CLC_RESPONDCVARVALUE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetCookie", MT_CLC_RespondCvarValue::GetCookie);
			__index->SetMember("SetCookie", MT_CLC_RespondCvarValue::SetCookie);

			__index->SetMember("GetConVarName", MT_CLC_RespondCvarValue::GetConVarName);
			__index->SetMember("SetConVarName", MT_CLC_RespondCvarValue::SetConVarName);

			__index->SetMember("GetConVarValue", MT_CLC_RespondCvarValue::GetConVarValue);
			__index->SetMember("SetConVarValue", MT_CLC_RespondCvarValue::SetConVarValue);

			__index->SetMember("GetStatus", MT_CLC_RespondCvarValue::GetStatus);
			__index->SetMember("SetStatus", MT_CLC_RespondCvarValue::SetStatus);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(CLC_VOICEDATA_NAME, CLC_VOICEDATA_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetSize", MT_CLC_VoiceData::GetSize);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(INETCHANNEL_NAME, INETCHANNEL_ID);
		__index = gLua->GetNewTable();
			//INetChannelInfo

			__index->SetMember("GetName", MT_INetChannel::GetName);
			__index->SetMember("GetAddress", MT_INetChannel::GetAddress);
			__index->SetMember("GetTime", MT_INetChannel::GetTime);
			__index->SetMember("GetTimeConnected", MT_INetChannel::GetTimeConnected);
			__index->SetMember("GetBufferSize", MT_INetChannel::GetBufferSize);
			__index->SetMember("GetDataRate", MT_INetChannel::GetDataRate);
			
			__index->SetMember("IsLoopback", MT_INetChannel::IsLoopback);
			__index->SetMember("IsTimingOut", MT_INetChannel::IsTimingOut);
			__index->SetMember("IsPlayback", MT_INetChannel::IsPlayback);

			__index->SetMember("GetLatency", MT_INetChannel::GetLatency);
			__index->SetMember("GetAvgLatency", MT_INetChannel::GetAvgLatency);
			__index->SetMember("GetAvgLoss", MT_INetChannel::GetAvgLoss);
			__index->SetMember("GetAvgChoke", MT_INetChannel::GetAvgChoke);
			__index->SetMember("GetAvgData", MT_INetChannel::GetAvgData);
			__index->SetMember("GetAvgPackets", MT_INetChannel::GetAvgPackets);
			__index->SetMember("GetTotalData", MT_INetChannel::GetTotalData);
			__index->SetMember("GetSequenceNr", MT_INetChannel::GetSequenceNr);
			__index->SetMember("IsValidPacket", MT_INetChannel::IsValidPacket);
			__index->SetMember("GetPacketTime", MT_INetChannel::GetPacketTime);
			__index->SetMember("GetPacketBytes", MT_INetChannel::GetPacketBytes);
			__index->SetMember("GetStreamProgress", MT_INetChannel::GetStreamProgress);
			__index->SetMember("GetTimeSinceLastReceived", MT_INetChannel::GetTimeSinceLastReceived);
			__index->SetMember("GetCommandInterpolationAmount", MT_INetChannel::GetCommandInterpolationAmount);
			__index->SetMember("GetPacketResponseLatency", MT_INetChannel::GetPacketResponseLatency);
			__index->SetMember("GetRemoteFramerate", MT_INetChannel::GetRemoteFramerate);

			__index->SetMember("GetTimeoutSeconds", MT_INetChannel::GetTimeoutSeconds);

			//INetChannel

			__index->SetMember("SetDataRate", MT_INetChannel::SetDataRate);
			__index->SetMember("RegisterMessage", MT_INetChannel::RegisterMessage);
			__index->SetMember("StartStreaming", MT_INetChannel::StartStreaming);
			__index->SetMember("ResetStreaming", MT_INetChannel::ResetStreaming);
			__index->SetMember("SetTimeout", MT_INetChannel::SetTimeout);
			__index->SetMember("SetChallengeNr", MT_INetChannel::SetChallengeNr);
			
			__index->SetMember("Reset", MT_INetChannel::Reset);
			__index->SetMember("Clear", MT_INetChannel::Clear);
			__index->SetMember("Shutdown", MT_INetChannel::Shutdown);
			
			__index->SetMember("ProcessPlayback", MT_INetChannel::ProcessPlayback);
			__index->SetMember("ProcessStream", MT_INetChannel::ProcessStream);
					
			__index->SetMember("SendNetMsg", MT_INetChannel::SendNetMsg);
			__index->SetMember("SendFile", MT_INetChannel::SendFile);
			__index->SetMember("DenyFile", MT_INetChannel::DenyFile);
			__index->SetMember("SetChoked", MT_INetChannel::SetChoked);
			__index->SetMember("Transmit", MT_INetChannel::Transmit);

			__index->SetMember("GetDropNumber", MT_INetChannel::GetDropNumber);
			__index->SetMember("GetSocket", MT_INetChannel::GetSocket);
			__index->SetMember("GetChallengeNr", MT_INetChannel::GetChallengeNr);
			__index->SetMember("GetSequenceData", MT_INetChannel::GetSequenceData);
			__index->SetMember("SetSequenceData", MT_INetChannel::SetSequenceData);
				
			__index->SetMember("UpdateMessageStats", MT_INetChannel::UpdateMessageStats);
			__index->SetMember("CanPacket", MT_INetChannel::CanPacket);
			__index->SetMember("IsOverflowed", MT_INetChannel::IsOverflowed);
			__index->SetMember("IsTimedOut", MT_INetChannel::IsTimedOut);
			__index->SetMember("HasPendingReliableData", MT_INetChannel::HasPendingReliableData);

			__index->SetMember("SetFileTransmissionMode", MT_INetChannel::SetFileTransmissionMode);
			__index->SetMember("SetCompressionMode", MT_INetChannel::SetCompressionMode);
			__index->SetMember("RequestFile", MT_INetChannel::RequestFile);

			__index->SetMember("SetMaxBufferSize", MT_INetChannel::SetMaxBufferSize);

			__index->SetMember("IsNull", MT_INetChannel::IsNull);
			__index->SetMember("GetNumBitsWritten", MT_INetChannel::GetNumBitsWritten);
			__index->SetMember("SetInterpolationAmount", MT_INetChannel::SetInterpolationAmount);
			__index->SetMember("SetRemoteFramerate", MT_INetChannel::SetRemoteFramerate);

			__index->SetMember("SetMaxRoutablePayloadSize", MT_INetChannel::SetMaxRoutablePayloadSize);
			__index->SetMember("GetMaxRoutablePayloadSize", MT_INetChannel::GetMaxRoutablePayloadSize);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(INETMESSAGE_NAME, INETMESSAGE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("To", MT_INetMessage::To);

			__index->SetMember("SetReliable", MT_INetMessage::SetReliable);

			__index->SetMember("Process", MT_INetMessage::Process);

			__index->SetMember("IsReliable", MT_INetMessage::IsReliable);

			__index->SetMember("GetType", MT_INetMessage::GetType);
			__index->SetMember("GetGroup", MT_INetMessage::GetGroup);
			__index->SetMember("GetName", MT_INetMessage::GetName);
			__index->SetMember("GetNetChannel", MT_INetMessage::GetNetChannel);
			__index->SetMember("ToString", MT_INetMessage::ToString);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(NET_SETCONVAR_NAME, NET_SETCONVAR_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetConVarCount", MT_NET_SetConVar::GetConVarCount);
			__index->SetMember("SetConVarCount", MT_NET_SetConVar::SetConVarCount);

			__index->SetMember("GetConVar", MT_NET_SetConVar::GetConVar);
			__index->SetMember("SetConVar", MT_NET_SetConVar::SetConVar);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(NET_SIGNONSTATE_NAME, NET_SIGNONSTATE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetState", MT_NET_SignonState::GetState);
			__index->SetMember("SetState", MT_NET_SignonState::SetState);

			__index->SetMember("GetCount", MT_NET_SignonState::GetCount);
			__index->SetMember("SetCount", MT_NET_SignonState::SetCount);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();
	
	metaT = gLua->GetMetaTable(NET_STRINGCMD_NAME, NET_STRINGCMD_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetCommand", MT_NET_StringCmd::GetCommand);
			__index->SetMember("SetCommand", MT_NET_StringCmd::SetCommand);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(NET_TICK_NAME, NET_TICK_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetTick", MT_NET_Tick::GetTick);
			__index->SetMember("SetTick", MT_NET_Tick::SetTick);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_BSPDECAL_NAME, SVC_BSPDECAL_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_CLASSINFO_NAME, SVC_CLASSINFO_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_CREATESTRINGTABLE_NAME, SVC_CREATESTRINGTABLE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetTableName", MT_SVC_CreateStringTable::GetTableName);
			__index->SetMember("SetTableName", MT_SVC_CreateStringTable::SetTableName);

			__index->SetMember("GetEntryCount", MT_SVC_CreateStringTable::GetEntryCount);
			__index->SetMember("SetEntryCount", MT_SVC_CreateStringTable::SetEntryCount);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_CROSSHAIRANGLE_NAME, SVC_CROSSHAIRANGLE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_ENTITYMESSAGE_NAME, SVC_ENTITYMESSAGE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_FIXANGLE_NAME, SVC_FIXANGLE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();
	
	metaT = gLua->GetMetaTable(SVC_GAMEEVENT_NAME, SVC_GAMEEVENT_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_GAMEEVENTLIST_NAME, SVC_GAMEEVENTLIST_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_GETCVARVALUE_NAME, SVC_GETCVARVALUE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetCookie", MT_SVC_GetCvarValue::GetCookie);
			__index->SetMember("SetCookie", MT_SVC_GetCvarValue::SetCookie);

			__index->SetMember("GetConVarName", MT_SVC_GetCvarValue::GetConVarName);
			__index->SetMember("SetConVarName", MT_SVC_GetCvarValue::SetConVarName);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_MENU_NAME, SVC_MENU_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_PACKETENTITIES_NAME, SVC_PACKETENTITIES_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_PREFETCH_NAME, SVC_PREFETCH_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_PRINT_NAME, SVC_PRINT_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_SENDTABLE_NAME, SVC_SENDTABLE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_SERVERINFO_NAME, SVC_SERVERINFO_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_SETPAUSE_NAME, SVC_SETPAUSE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_SETVIEW_NAME, SVC_SETVIEW_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_SOUNDS_NAME, SVC_SOUNDS_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_TEMPENTITIES_NAME, SVC_TEMPENTITIES_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_TERRAINMOD_NAME, SVC_TERRAINMOD_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_UPDATESTRINGTABLE_NAME, SVC_UPDATESTRINGTABLE_ID);
		__index = gLua->GetNewTable();	
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetTableType", MT_SVC_UpdateStringTable::GetTableType);
			__index->SetMember("SetTableType", MT_SVC_UpdateStringTable::SetTableType);

			__index->SetMember("GetChangedCount", MT_SVC_UpdateStringTable::GetChangedCount);
			__index->SetMember("SetChangedCount", MT_SVC_UpdateStringTable::SetChangedCount);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_USERMESSAGE_NAME, SVC_USERMESSAGE_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetSize", MT_SVC_UserMessage::GetSize);

			__index->SetMember("GetType", MT_SVC_UserMessage::GetType);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_VOICEDATA_NAME, SVC_VOICEDATA_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			__index->SetMember("GetClientIndex", MT_SVC_VoiceData::GetClientIndex);
			__index->SetMember("SetClientIndex", MT_SVC_VoiceData::SetClientIndex);

			__index->SetMember("GetSize", MT_SVC_VoiceData::GetSize);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	metaT = gLua->GetMetaTable(SVC_VOICEINIT_NAME, SVC_VOICEINIT_ID);
		__index = gLua->GetNewTable();
			__index->SetMember("ToBase", NMToBase);

			metaT->SetMember("__index", __index);
		__index->UnReference();
	metaT->UnReference();

	CreateInterfaceFn engineFactory = Sys_GetFactory("engine.dll");

	CSigScan::sigscan_dllfunc = (CreateInterfaceFn)engineFactory(INTERFACEVERSION_VENGINESERVER, NULL);
	CSigScan::GetDllMemInfo();

	client = gLua->IsClient();

	if (!client)
	{
		gLua->SetGlobal("GetNetChannel", SV_GetNetChannel);

		sv_engine = (IVEngineServer *)engineFactory(INTERFACEVERSION_VENGINESERVER, NULL);

		ATTACHPROCESSFUNC(SV, SetConVar, "\x55\x56\x57\x8B\x7C\x24\x10\x33\xF6\x39\x77\x1C", "xxxxxxxxxxxx", 12);
		ATTACHPROCESSFUNC(SV, SignonState, "\x56\x57\x8B\x7C\x24\x0C\x8B\x47\x10\x83\xF8\x07", "xxxxxxxxxxxx", 12);
		ATTACHPROCESSFUNC(SV, StringCmd, "\x8B\x54\x24\x04\x8B\x41\xFC\x8B\x52\x10\x8B\x40\x6C", "xxxxxxxxxxxxx", 13);
		ATTACHPROCESSFUNC(SV, Tick, "\x56\x57\x8B\x7C\x24\x0C\xD9\x47\x18\x8B\xF1\x8B\x8E\xD0\x00\x00\x00\x8B\x01", "xxxxxxxxxxxxxxxxxxx", 19);

		ATTACHPROCESSFUNC(SV, BaselineAck, "\x8B\x54\x24\x04\x53\x8B\xD9\x8B\x4A\x10", "xxxxxxxxxx", 10);
		ATTACHPROCESSFUNC(SV, ClientInfo, "\x8B\x44\x24\x04\x56\x50\x8B\xF1\xE8\x33\x3E\xF6\xFF\x80\xBE\xA4\x00\x00\x00\x00\x74\x1A", "xxxxxxxxx????xxxxxxxx?", 22);
		//ATTACHPROCESSFUNC(SV, FileCRCCheck, "", "", 0);
		ATTACHPROCESSFUNC(SV, ListenEvents, "\x53\x56\x57\x8D\x79\xF8\x8B\x0D\x4C\xB9\x35\x10", "xxxxxxxx????", 12);
		ATTACHPROCESSFUNC(SV, Move, "\x83\xEC\x10\x53\x8B\xD9\x8B\x43\xFC", "xxxxxxxxx", 9);
		ATTACHPROCESSFUNC(SV, RespondCvarValue, "\x8B\x44\x24\x04\x8B\x50\x10\x85\xD2\x56\x8B\xF1", "xxxxxxxxxxxx", 12);
		ATTACHPROCESSFUNC(SV, VoiceData, "\xB8\x00\x10\x00\x00\xE8\x56\x6F\x11\x00\x56\x8B\xB4\x24\x08\x10\x00\x00\x8B\x46\x10", "xxxxxx????xxxxxxxxxxx", 21);
	}
	else
	{
		loadcount++;

		gLua->SetGlobal("GetNetChannel", CL_GetNetChannel);

		if (loadcount > 1)
			return 0;

		cl_engine = (IVEngineClient *)engineFactory(VENGINE_CLIENT_INTERFACE_VERSION, NULL);

		ATTACHPROCESSFUNC(CL, SetConVar, "\x8B\x49\x08\x8B\x01\x8B\x50\x18\x83\xEC\x0C\xFF\xD2", "xxxxxxxxxxxxx", 13);
		ATTACHPROCESSFUNC(CL, SignonState, "\x8B\x44\x24\x04\x8B\x51\xF8\x8B\x52\x30\x56", "xxxxxxxxxxx", 11);
		ATTACHPROCESSFUNC(CL, StringCmd, "\x0F\xB6\x81\x60\x4A\x00\x00\x8B\x54\x24\x04\x50\x52\x83\xC1\xF8", "xxxxxxxxxxxxxxxx", 16);
		ATTACHPROCESSFUNC(CL, Tick, "\x8B\x44\x24\x04\xD9\x40\x18\x56\x8B\x70\x10\x57", "xxxxxxxxxxxx", 12);

		ATTACHPROCESSFUNC(CL, BSPDecal, "\x56\x8B\x74\x24\x08\x83\x7E\x20\x00\x57", "xxxxxxxxxx", 10);
		ATTACHPROCESSFUNC(CL, ClassInfo, "\x8B\x44\x24\x04\x80\x78\x10\x00\x56\x8B\xF1\x74\x52", "xxxxxxxxxxxx?", 13);
		ATTACHPROCESSFUNC(CL, CreateStringTable, "\x53\x55\x56\x57\x8B\xD9\xE8\x75\x02\x0F\x00\x8B\x10\x8B\xC8\x8B\x42\x68\x6A\x11", "xxxxxxx????xxxxxxxxx", 20);
		ATTACHPROCESSFUNC(CL, CrosshairAngle, "\x8B\x44\x24\x04\x83\xEC\x1C\x56\x50", "xxxxxxxxx", 9);	
		ATTACHPROCESSFUNC(CL, EntityMessage, "\x8B\x0D\x58\x61\x3E\x10\x8B\x01\x8B\x00\x81\xEC\x24\x01\x00\x00\x55\x57", "xx????xxxxxxxxxxxx", 18);
		ATTACHPROCESSFUNC(CL, FixAngle, "\x8B\x44\x24\x04\xF3\x0F\x10\x48\x14", "xxxxxxxxx", 9);
		ATTACHPROCESSFUNC(CL, GameEvent, "\x53\x8B\x5C\x24\x08\x8B\x43\x34\x85\xC0\x56", "xxxxxxxxxxx", 11);
		ATTACHPROCESSFUNC(CL, GameEventList, "\x8B\x0D\x4C\xB9\x39\x10\xE9\xB5\x9B\xF8\xFF\xCC\xCC\xCC\xCC\xCC\x83\xEC\x10", "xx????x????xxxxxxxx", 19);
		ATTACHPROCESSFUNC(CL, GetCvarValue, "\x81\xEC\x20\x03\x00\x00\x55\x56\x57\x8B\xBC\x24\x30\x03\x00\x00\x8B\x47\x10", "xxxxxxxxxxxxxxxxxxx", 19);
		ATTACHPROCESSFUNC(CL, Menu, "\x8B\x44\x24\x04\x50\xE8\xF6\x15\x02\x00\x83\xC4\x04\xB0\x01\xC2\x04\x00", "xxxxxx????xxxxxxxx", 18); //Untested
		ATTACHPROCESSFUNC(CL, PacketEntities, "\x56\x57\x8B\xF1\xE8\xF7\xE8\x03\x00\x8B\x7C\x24\x0C\x80\x7F\x18\x00\x75\x22", "xxxxx????xxxxxxxxx?", 19);
		//ATTACHPROCESSFUNC(CL, Prefetch, "", "", 0);
		ATTACHPROCESSFUNC(CL, Print, "\x8B\x44\x24\x04\x8B\x48\x10\x51\xFF\x15\x68\x75\x2D\x10\x83\xC4\x04", "xxxxxxxxxx????xxx", 17); //FIXME
		ATTACHPROCESSFUNC(CL, SendTable, "\x8B\x44\x24\x04\x0F\xB6\x48\x10\x6A\x00\x51", "xxxxxxxxxxx", 11);
		ATTACHPROCESSFUNC(CL, ServerInfo, "\x56\x57\x8B\xF1\xE8\xB7\x08\x04\x00\x8B\x7C\x24\x0C\x57", "xxxxx????xxxxx", 14);
		ATTACHPROCESSFUNC(CL, SetPause, "\x8B\x44\x24\x04\x50\xE8\x46\x45\x02\x00\xB0\x01", "xxxxxx????xx", 12);
		ATTACHPROCESSFUNC(CL, SetView, "\x8B\x44\x24\x04\x8B\x50\x10\x89\x91\x8C\x01\x00\x00\xB0\x01\xC2\x04\x00", "xxxxxxxxxxxxxxxxxx", 18);
		ATTACHPROCESSFUNC(CL, Sounds, "\x81\xEC\xBC\x00\x00\x00\x0F\x57\xC0\xF3\x0F\x10\x0D\x7C\x93\x2D\x10\x53\x33\xDB", "xxxxxxxxxxxxx????xxx", 20);
		//ATTACHPROCESSFUNC(CL, TempEntities, "", "", 0);
		//ATTACHPROCESSFUNC(CL, TerrainMod, "", "", 0);
		ATTACHPROCESSFUNC(CL, UpdateStringTable, "\x53\x56\x57\x8B\x7C\x24\x10\x8B\x47\x3C\x85\xC0", "xxxxxxxxxxxx", 12);
		ATTACHPROCESSFUNC(CL, UserMessage, "\x81\xEC\x24\x01\x00\x00\x56\x68\xFE\x00\x00\x00\x8D\x44\x24\x2D\x6A\x00\x50", "xxxxxxxxxxxxxxxxxxx", 19);
		ATTACHPROCESSFUNC(CL, VoiceData, "\xB8\x88\x10\x00\x00\xE8\x96\x47\x1D\x00\x53", "xxxxxx????x", 11);
		ATTACHPROCESSFUNC(CL, VoiceInit, "\x8B\x44\x24\x04\x8B\x40\x10\x80\x38\x00\x75\x0A", "xxxxxxxxxxx?", 12);
	}

	/*ProcessNetMsg_Sig.Init((unsigned char *)"\xC6\x43\x04\x01\x8B\x06\x8B\x50\x0C\x8B\xCE\xFF\xD2", "xxxxxxxxxxxxx", 13);

	if (ProcessNetMsg_Sig.is_set)
	{
		CDetour::ProcessNetMsgT = *((ProcessNetMsg_t)&ProcessNetMsg_Sig.sig_addr);

		DetourTransactionBegin();
		DetourUpdateThread(GetCurrentThread());
			
		DetourAttach(&(PVOID &)CDetour::ProcessNetMsgT, (PVOID)(&(PVOID &)CDetour::ProcessNetMsg));

		DetourTransactionCommit();
	}
	else
	{
		gLua->Msg("[ProcessNetMsg] SS failed\n");
	}*/

	INetChannel_SendNetMsg_Sig.Init((unsigned char *)"\x56\x8B\xF1\x8D\x8E\x98\x00\x00\x00\xE8\x42\x7D\x0B\x00\x85\xC0\x75\x06\xB0\x01\x5E\xC2\x0C\x00", "xxxxxxxxxx????xxx?xxxxxx", 24);
	
	if (INetChannel_SendNetMsg_Sig.is_set)
	{ 
		CDetour::INetChannel_SendNetMsgT = *((INetChannel_SendNetMsg_t)&INetChannel_SendNetMsg_Sig.sig_addr);

		DetourTransactionBegin();
		DetourUpdateThread(GetCurrentThread());
			
		DetourAttach(&(PVOID &)CDetour::INetChannel_SendNetMsgT, (PVOID)(&(PVOID &)CDetour::INetChannel_SendNetMsg));

		DetourTransactionCommit();
	}
	else
	{
		gLua->Msg("[INetChannel::SendNetMsg] Failed\n");
	}

	/*INetChannel_SendDatagram_Sig.Init((unsigned char *)"\xB8\x8C\x77\x01\x00\xE8\x06\x26\x1F\x00\xA1\x44\x3D\xDB\x0C\x83\x78\x30\x00\x55", "xxxxxx????x????xxxxx", 20);

	if (INetChannel_SendDatagram_Sig.is_set)
	{
		CDetour::INetChannel_SendDatagramT = *((INetChannel_SendDatagram_t)&INetChannel_SendDatagram_Sig.sig_addr);

		DetourTransactionBegin();
		DetourUpdateThread(GetCurrentThread());

		DetourAttach(&(PVOID &)CDetour::INetChannel_SendDatagramT, (PVOID)(&(PVOID &)CDetour::INetChannel_SendDatagram));

		DetourTransactionCommit();
	}
	else
	{
		gLua->Msg("[INetChannel::SendDatagram] Failed\n");
	}*/

	return 0;
}

int Unload(lua_State *L)
{
	if (!client)
	{
		DETACHPROCESSFUNC(SV, SetConVar);
		DETACHPROCESSFUNC(SV, SignonState);
		DETACHPROCESSFUNC(SV, StringCmd);
		DETACHPROCESSFUNC(SV, Tick);

		DETACHPROCESSFUNC(SV, BaselineAck);
		DETACHPROCESSFUNC(SV, ClientInfo);
		//DETACHPROCESSFUNC(SV, FileCRCCheck);
		DETACHPROCESSFUNC(SV, ListenEvents);
		DETACHPROCESSFUNC(SV, Move);
		DETACHPROCESSFUNC(SV, RespondCvarValue);
		DETACHPROCESSFUNC(SV, VoiceData);
	}
	else
	{
		loadcount--;

		if (loadcount >= 1)
			return 0;

		DETACHPROCESSFUNC(CL, SetConVar);
		DETACHPROCESSFUNC(CL, SignonState);
		DETACHPROCESSFUNC(CL, StringCmd);
		DETACHPROCESSFUNC(CL, Tick);

		DETACHPROCESSFUNC(CL, BSPDecal);
		DETACHPROCESSFUNC(CL, ClassInfo);
		DETACHPROCESSFUNC(CL, CreateStringTable);
		DETACHPROCESSFUNC(CL, CrosshairAngle);
		DETACHPROCESSFUNC(CL, EntityMessage);
		DETACHPROCESSFUNC(CL, FixAngle);
		DETACHPROCESSFUNC(CL, GameEvent);
		DETACHPROCESSFUNC(CL, GameEventList);
		DETACHPROCESSFUNC(CL, GetCvarValue);
		DETACHPROCESSFUNC(CL, Menu);
		DETACHPROCESSFUNC(CL, PacketEntities);
		//DETACHPROCESSFUNC(CL, Prefetch);
		DETACHPROCESSFUNC(CL, Print);
		DETACHPROCESSFUNC(CL, SendTable);
		DETACHPROCESSFUNC(CL, ServerInfo);
		DETACHPROCESSFUNC(CL, SetPause);
		DETACHPROCESSFUNC(CL, SetView);
		DETACHPROCESSFUNC(CL, Sounds);
		//DETACHPROCESSFUNC(CL, TempEntities);
		//DETACHPROCESSFUNC(CL, TerrainMod);
		DETACHPROCESSFUNC(CL, UpdateStringTable);
		DETACHPROCESSFUNC(CL, UserMessage);
		DETACHPROCESSFUNC(CL, VoiceData);
		DETACHPROCESSFUNC(CL, VoiceInit);
	}

	if (INetChannel_SendNetMsg_Sig.is_set)
	{
		DetourTransactionBegin();
		DetourUpdateThread(GetCurrentThread());

		DetourDetach(&(PVOID &)CDetour::INetChannel_SendNetMsgT, (PVOID)(&(PVOID &)CDetour::INetChannel_SendNetMsg));

		DetourTransactionCommit();
	}

	/*if (INetChannel_SendDatagram_Sig.is_set)
	{
		DetourTransactionBegin();
		DetourUpdateThread(GetCurrentThread());

		DetourDetach(&(PVOID &)CDetour::INetChannel_SendDatagramT, (PVOID)(&(PVOID &)CDetour::INetChannel_SendDatagram));

		DetourTransactionCommit();
	}*/

	return 0;
}