#ifndef CDETOUR_H
#define CDETOUR_H

#include <inetmessage.h>
#include <inetmsghandler.h>

#include "detours/include/detours.h"

#define PROCESSFUNCMEMBER(side, type, name) bool side##_Process##name##(type##_##name *); \
	static bool (CDetour::* side##_Process##name##T)(type##_##name *)

#define PROCESSFUNCDECLARE(side, type, name) bool (CDetour::* CDetour::side##_Process##name##T)(type##_##name *) = NULL

#define PROCESSFUNCTYPE(side, type, name) typedef bool (__thiscall CDetour::* *side##_Process##name##_t)(type##_##name *)

class CDetour
{
public:
	PROCESSFUNCMEMBER(CL, NET, SetConVar);
	PROCESSFUNCMEMBER(CL, NET, SignonState);
	PROCESSFUNCMEMBER(CL, NET, StringCmd);
	PROCESSFUNCMEMBER(CL, NET, Tick);

	PROCESSFUNCMEMBER(CL, SVC, BSPDecal);
	PROCESSFUNCMEMBER(CL, SVC, ClassInfo);
	PROCESSFUNCMEMBER(CL, SVC, CreateStringTable);
	PROCESSFUNCMEMBER(CL, SVC, CrosshairAngle);
	PROCESSFUNCMEMBER(CL, SVC, EntityMessage);
	PROCESSFUNCMEMBER(CL, SVC, FixAngle);
	PROCESSFUNCMEMBER(CL, SVC, GameEvent);
	PROCESSFUNCMEMBER(CL, SVC, GameEventList);
	PROCESSFUNCMEMBER(CL, SVC, GetCvarValue);
	PROCESSFUNCMEMBER(CL, SVC, Menu);
	PROCESSFUNCMEMBER(CL, SVC, PacketEntities);
	PROCESSFUNCMEMBER(CL, SVC, Prefetch);
	PROCESSFUNCMEMBER(CL, SVC, Print);
	PROCESSFUNCMEMBER(CL, SVC, SendTable);
	PROCESSFUNCMEMBER(CL, SVC, ServerInfo);
	PROCESSFUNCMEMBER(CL, SVC, SetPause);
	PROCESSFUNCMEMBER(CL, SVC, SetView);
	PROCESSFUNCMEMBER(CL, SVC, Sounds);
	PROCESSFUNCMEMBER(CL, SVC, TempEntities);
	//PROCESSFUNCMEMBER(CL, SVC, TerrainMod);
	PROCESSFUNCMEMBER(CL, SVC, UpdateStringTable);
	PROCESSFUNCMEMBER(CL, SVC, UserMessage);
	PROCESSFUNCMEMBER(CL, SVC, VoiceData);
	PROCESSFUNCMEMBER(CL, SVC, VoiceInit);

	PROCESSFUNCMEMBER(SV, NET, SetConVar);
	PROCESSFUNCMEMBER(SV, NET, SignonState);
	PROCESSFUNCMEMBER(SV, NET, StringCmd);
	PROCESSFUNCMEMBER(SV, NET, Tick);

	PROCESSFUNCMEMBER(SV, CLC, BaselineAck);
	PROCESSFUNCMEMBER(SV, CLC, ClientInfo);
	PROCESSFUNCMEMBER(SV, CLC, FileCRCCheck);
	PROCESSFUNCMEMBER(SV, CLC, ListenEvents);
	PROCESSFUNCMEMBER(SV, CLC, Move);
	PROCESSFUNCMEMBER(SV, CLC, RespondCvarValue);
	PROCESSFUNCMEMBER(SV, CLC, VoiceData);

	//void ProcessNetMsg();
	bool SendNetMsgL(INetMessage &, bool, bool);

	bool INetChannel_SendNetMsg(INetMessage &, bool, bool);
	int INetChannel_SendDatagram(bf_write *);
	
	//static void (CDetour::* ProcessNetMsgT)();
	static bool (CDetour::* INetChannel_SendNetMsgT)(INetMessage &, bool, bool);
	static int (CDetour::* INetChannel_SendDatagramT)(bf_write *);
};

PROCESSFUNCTYPE(CL, NET, SetConVar);
PROCESSFUNCTYPE(CL, NET, SignonState);
PROCESSFUNCTYPE(CL, NET, StringCmd);
PROCESSFUNCTYPE(CL, NET, Tick);

PROCESSFUNCTYPE(CL, SVC, BSPDecal);
PROCESSFUNCTYPE(CL, SVC, ClassInfo);
PROCESSFUNCTYPE(CL, SVC, CreateStringTable);
PROCESSFUNCTYPE(CL, SVC, CrosshairAngle);
PROCESSFUNCTYPE(CL, SVC, EntityMessage);
PROCESSFUNCTYPE(CL, SVC, FixAngle);
PROCESSFUNCTYPE(CL, SVC, GameEvent);
PROCESSFUNCTYPE(CL, SVC, GameEventList);
PROCESSFUNCTYPE(CL, SVC, GetCvarValue);
PROCESSFUNCTYPE(CL, SVC, Menu);
PROCESSFUNCTYPE(CL, SVC, PacketEntities);
PROCESSFUNCTYPE(CL, SVC, Prefetch);
PROCESSFUNCTYPE(CL, SVC, Print);
PROCESSFUNCTYPE(CL, SVC, SendTable);
PROCESSFUNCTYPE(CL, SVC, ServerInfo);
PROCESSFUNCTYPE(CL, SVC, SetPause);
PROCESSFUNCTYPE(CL, SVC, SetView);
PROCESSFUNCTYPE(CL, SVC, Sounds);
PROCESSFUNCTYPE(CL, SVC, TempEntities);
//PROCESSFUNCTYPE(CL, SVC, TerrainMod);
PROCESSFUNCTYPE(CL, SVC, UpdateStringTable);
PROCESSFUNCTYPE(CL, SVC, UserMessage);
PROCESSFUNCTYPE(CL, SVC, VoiceData);
PROCESSFUNCTYPE(CL, SVC, VoiceInit);

PROCESSFUNCTYPE(SV, NET, SetConVar);
PROCESSFUNCTYPE(SV, NET, SignonState);
PROCESSFUNCTYPE(SV, NET, StringCmd);
PROCESSFUNCTYPE(SV, NET, Tick);

PROCESSFUNCTYPE(SV, CLC, BaselineAck);
PROCESSFUNCTYPE(SV, CLC, ClientInfo);
PROCESSFUNCTYPE(SV, CLC, FileCRCCheck);
PROCESSFUNCTYPE(SV, CLC, ListenEvents);
PROCESSFUNCTYPE(SV, CLC, Move);
PROCESSFUNCTYPE(SV, CLC, RespondCvarValue);
PROCESSFUNCTYPE(SV, CLC, VoiceData);

//typedef void (__thiscall CDetour::* *ProcessNetMsg_t)();
typedef bool (__thiscall CDetour::* *INetChannel_SendNetMsg_t)(INetMessage &, bool, bool);
typedef int (__thiscall CDetour::* *INetChannel_SendDatagram_t)(bf_write *);

#endif //CDETOUR_H